﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;


/*  A simple sequential workflow hosted by a console application  
  
    Windows Workflow Foundation (WWF)
    Workflows and Activities
    WorkflowRuntime class and WorkflowInstance class
 
 
    WARNING: Workflows are not executed by the primary thread. Instead they
             executed by secondary threads created by the WWF runtime engine 
             and in some cases by threads a host application lends to the WWF runtime engine.
 */
namespace Lessons.Workflows
{
    class Program
    {
        static void Main(string[] args)
        {
            /*  WorkflowRuntime class represents the WWF runtime engine 
                WorkflowInstance class represents an instance of a workflow class
                Workflows are executed by the WWF runtime engine 
                An application hosts WWF runtime engine in order to execute workflows*/
            using (WorkflowRuntime workflowRuntime = new WorkflowRuntime())
            {
                AutoResetEvent waitHandle = new AutoResetEvent(false);


                /* using anonymous methods as event handlers for WorkflowRuntime events */
                workflowRuntime.WorkflowCompleted += delegate(object sender, WorkflowCompletedEventArgs e) 
                { 
                    /* unblock the current thread upon completion of the workflow */
                    waitHandle.Set();                 
                };


                workflowRuntime.WorkflowTerminated += delegate(object sender, WorkflowTerminatedEventArgs e)
                {
                    Console.WriteLine(e.Exception.Message);
                    waitHandle.Set();
                };

                
                /* create a workflow instance and start it */
                WorkflowInstance instance = workflowRuntime.CreateWorkflow(typeof(Lessons.Workflows.Workflow1));
                instance.Start();


                /* block the current thread until workflow termination or completion */
                waitHandle.WaitOne();

                Console.WriteLine("Hit <ENTER> key to exit");
                Console.ReadLine();
            }
        }
    }
}
